/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2008. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  
 * Use, duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp. 
 *******************************************************************************/
package junit.awtui;

import java.awt.*;
import java.awt.event.*;

import junit.runner.Version;

/**
 * This dialog shows "About information
 * This is not intended to be extended
 */
class AboutDialog extends Dialog {
	
	private static final String DIALOG = "dialog"; //$NON-NLS-1$

	/**
     * Constructs an initially invisible, non-modal <code>Dialog</code> with 
     * about information and the specified owner frame.
     *
     * @param owner the owner of the dialog
	 */
	public AboutDialog(Frame parent) {
		super(parent);
		// fix
		setResizable(false);
		setLayout(new GridBagLayout());
		setSize(330, 138);
		setTitle("About"); //$NON-NLS-1$
		// fix2
		Button button= new Button("Close"); //$NON-NLS-1$
		button.addActionListener(
			new	ActionListener() {
			    /**
			     * Invoked when an action occurs.
			     */
				public void actionPerformed(ActionEvent e) {
					dispose();
				}
			}
		);
		
		Label label1= new Label("JUnit"); //$NON-NLS-1$
		label1.setFont(new Font(DIALOG, Font.PLAIN, 36)); //$NON-NLS-1$
		
		// Give credit to authors
		Label label2= new Label("JUnit "+ Version.id() + " by Kent Beck and Erich Gamma"); //$NON-NLS-2$
		label2.setFont(new Font(DIALOG, Font.PLAIN, 14));
		
		Logo logo= new Logo();

		GridBagConstraints constraintsLabel1= new GridBagConstraints();
		constraintsLabel1.gridx = 2; constraintsLabel1.gridy = 0;
		constraintsLabel1.gridwidth = 1; constraintsLabel1.gridheight = 1;
		constraintsLabel1.anchor = GridBagConstraints.CENTER;
		add(label1, constraintsLabel1);

		GridBagConstraints constraintsLabel2= new GridBagConstraints();
		constraintsLabel2.gridx = 2; constraintsLabel2.gridy = 1;
		constraintsLabel2.gridwidth = 2; constraintsLabel2.gridheight = 1;
		constraintsLabel2.anchor = GridBagConstraints.CENTER;
		add(label2, constraintsLabel2);

		GridBagConstraints constraintsButton1= new GridBagConstraints();
		constraintsButton1.gridx = 2; constraintsButton1.gridy = 2;
		constraintsButton1.gridwidth = 2; constraintsButton1.gridheight = 1;
		constraintsButton1.anchor = GridBagConstraints.CENTER;
		constraintsButton1.insets= new Insets(8, 0, 8, 0);
		add(button, constraintsButton1);

		GridBagConstraints constraintsLogo1= new GridBagConstraints();
		constraintsLogo1.gridx = 2; constraintsLogo1.gridy = 0;
		constraintsLogo1.gridwidth = 1; constraintsLogo1.gridheight = 1;
		constraintsLogo1.anchor = GridBagConstraints.CENTER;
		add(logo, constraintsLogo1);

		addWindowListener(
			new WindowAdapter() {

			    /**
			     * Invoked when a window is in the process of being closed.
			     */
				public void windowClosing(WindowEvent e) {
					dispose();
				}
			}
		);
	}
}